

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Add New Expense</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('expense-store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label for="category" class="form-label">Category:</label>
                                <select class="form-select select2 category" name="expense_category_id" required>
                                    <option value="" selected>Select Expense Category</option>
                                    <?php $__currentLoopData = $expense_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(old('expense_category_id') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->category_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['expense_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label for="expenseName" class="form-label">Expense Name:</label>
                                <input type="text" id="expenseName" class="form-control" name="expense_name"
                                    value="<?php echo e(old('expense_name')); ?>" placeholder="Enter Expense Name" required>
                                <?php $__errorArgs = ['expense_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label for="expenseAmount" class="form-label">Amount:</label>
                                <input type="number" id="expenseAmount" class="form-control" name="expense_amount"
                                    value="<?php echo e(old('expense_amount')); ?>" placeholder="Enter Expense Amount" required>
                                <?php $__errorArgs = ['expense_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label for="expense_date" class="form-label">Expense Date:</label>
                                <input type="date" id="expense_date" class="form-control" name="expense_date"
                                    value="<?php echo e(old('expense_date', date('Y-m-d'))); ?>">
                                <?php $__errorArgs = ['expense_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="attachment" class="form-label">Attachment:</label>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-upload me-5">
                                        <div class="avatar-preview">
                                            <img id="attachmentPreview" src="<?php echo e(asset('assets/img/logos/attach.png')); ?>"
                                                alt="Default Attachment" class="img-fluid" style="height:50px; width:50px">
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type="file" id="attachment" class="form-control file-upload-input"
                                            name="attachment" accept="image/*,application/pdf" onchange="previewFile(this)">
                                    </div>
                                </div>
                                <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn btn-primary me-2">Save Expense</button>
                            <a href="<?php echo e(route('expense-index')); ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function previewFile(input) {
            const preview = document.getElementById('attachmentPreview');
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                if (file.type.includes('image')) {
                    preview.src = reader.result;
                } else if (file.type.includes('pdf')) {
                    preview.src = "<?php echo e(asset('assets/img/logos/pdf.png')); ?>";
                } else {
                    preview.src = "<?php echo e(asset('assets/img/logos/file.png')); ?>";
                }
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = "<?php echo e(asset('assets/img/logos/attach.png')); ?>";
            }
        }
        $(document).ready(function () {
            $('.category').select2({
                placeholder: "Search or type a category",
                allowClear: true,
                tags: true,
                tokenSeparators: [',', ' '],
                createTag: function (params) {
                    return {
                        id: params.term,
                        text: params.term
                    };
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/expenses/add.blade.php ENDPATH**/ ?>