

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <!-- Card Header -->
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">All Payments</h5>
                        </div>
                        <a href="<?php echo e(route('product-payment-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp;
                            Add Payments</a>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body px-0 pt-0 pb-2">

                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0" id="myTable">
                            <thead>
                                <tr>
                                    <th
                                        class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                        S.NO</th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                        Purchase Code</th>
                                    
                                    <th
                                        class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                        Payment Status</th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                        Purchased Date</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7">
                                        Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $payments_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($index + 1); ?></td>
                                        <td class="ps-4">
                                            <p class="text-xs text-center font-weight-bold mb-0">
                                                <?php echo e($data->purchase_code ?? ''); ?>

                                            </p>
                                        </td>
                                        
                                        <td class="ps-4 text-center">
                                            <?php
                                                $totalAmount = $data->total_amount ?? 0;
                                                $paidAmount = $data->payments->sum('paid_amount') ?? 0;

                                                if ($paidAmount >= $totalAmount && $totalAmount > 0) {
                                                    $status = 'Paid';
                                                } elseif ($paidAmount > 0 && $paidAmount < $totalAmount) {
                                                    $status = 'Partially Paid';
                                                } else {
                                                    $status = 'Unpaid';
                                                }

                                                $badgeClass = [
                                                    'Paid' => 'bg-success',
                                                    'Partially Paid' => 'bg-warning text-dark',
                                                    'Unpaid' => 'bg-danger',
                                                ][$status] ?? 'bg-secondary';
                                            ?>

                                            <span class="badge <?php echo e($badgeClass); ?> text-xs text-center font-weight-bold">
                                                <?php echo e($status); ?>

                                            </span>
                                        </td>


                                        <td class="ps-4">
                                            <p class="text-xs text-center font-weight-bold mb-0">
                                                <?php echo e(\Carbon\Carbon::parse($data->purchase_date)->format('d-m-Y') ?? ''); ?>

                                            </p>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('product-payment-edit', $data->id)); ?>">
                                                <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                            </a>
                                            <span class="ms-2">
                                                <form action="<?php echo e(route('product-payment-delete', $data->id)); ?>" method="POST"
                                                    class="d-inline" id="delete-form-<?php echo e($data->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <i class="cursor-pointer fas fa-trash text-secondary"
                                                        onclick="confirmDelete(<?php echo e($data->id); ?>)"></i>
                                                </form>
                                            </span>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            $('[data-bs-toggle="tooltip"]').tooltip();
        });
    </script>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/product-payments/index.blade.php ENDPATH**/ ?>