@extends('layouts.layoutapp')

@section('content')
  <div class="row">
        <div class="col-12">
            <div class="card me-2">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            @if($type == 'edit')
                            <div>
                                <h5 class="mb-0">Edit Quote</h5>
                            </div>
                            @elseif($type == 'convert')
                            <div>
                                <h5 class="mb-0">Convert Quote</h5>
                            </div>
                            @endif
                        </div>
                    </div>

                    <form action="{{ route('quotes-update') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{$quote->id}}">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 mb-3">
                                    <label for="client_id" class="form-label">Client Name:</label>
                                    <input name="client_id" id="client_id" class="form-control" disabled value="{{ $quote->client->user->name ?? '' }}">
                                    <input type="hidden" name="client_id" value="{{$quote->client_id}}">
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="client_num" class="form-label">Client Number:</label>
                                    <div id="client_select">
                                        <select name="client_num" id="client_num_select" class="form-select" disabled>
                                            @forelse ($clients as $data)
                                                <option value="{{ $data->user->phone }}" {{ $quote->client->user->phone == $data->user->phone ? 'selected' : '' }}>
                                                    {{ $data->user->phone }}
                                                </option>
                                            @empty
                                                <option>No Client found</option>
                                            @endforelse
                                        </select>
                                    </div>
                                    @error('client_num')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="quote_id" class="form-label">Quotes Id:</label>
                                    <input type="text" id="quote_id" name="quote_id" class="form-control" value="{{ $quote->quote_id }}" readonly required>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="quote_date" class="form-label">Quotes Date:</label>
                                    <input type="date" id="quote_date" name="quote_date" value="{{ $quote->quote_date }}" class="form-control" required>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="due_date" class="form-label">Due Date:</label>
                                    <input type="date" id="due_date" name="due_date" class="form-control" value="{{ $quote->due_date }}" required>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="status" class="form-label">Status</label>
                                    <select name="status" id="status" class="form-select" required>
                                        <option value="3" {{ $quote->status == 3 ? 'selected' : '' }}>Draft</option>
                                    </select>
                                </div>
                            </div>
                            <hr>
                            <div>
                                <h5>Product Details:</h5>
                                <div class="row align-items-center">
                                    <div class="col-lg-4">
                                        <button type="button" id="add-row" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Row
                                        </button>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped text-sm" id="products-table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>#</th>
                                                <th>Product</th>
                                                <th>Avl. Qty</th>
                                                <th>Qty</th>
                                                <th>Unit Price</th>
                                                <th>Amount</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($quote->quotesItem as $index => $item)
                                                @php
                                                    $product = $products->firstWhere('id', $item->product_id);
                                                    $available_qty = $product ? $product->qty : 0;
                                                @endphp
                                                <tr class="product-row">
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        <select name="products[{{ $index + 1 }}][id]" class="form-select product-select" required>
                                                            <option value="">Select Product</option>
                                                            @foreach ($products as $product)
                                                                <option value="{{ $product->id }}" 
                                                                        data-available="{{ $product->qty }}" 
                                                                        data-amount="{{ $item->total }}" 
                                                                        data-price="{{ $product->unit_price }}"
                                                                        {{ $item->product_id == $product->id ? 'selected' : '' }}>
                                                                    {{ $product->code }}-{{ $product->branch->native_name_flag == 'A' ? ($product->native_name ?? $product->name) : $product->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="duplicate-warning-container"></div>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control available-qty" readonly value="{{ $available_qty }}">
                                                    </td>
                                                    <td>
                                                        <input type="number" name="products[{{ $index + 1 }}][qty]" 
                                                               class="form-control qty" min="1" value="{{ $item->quantity }}" required>
                                                    </td>
                                                    <td>
                                                        <input type="number" name="products[{{ $index + 1 }}][unit_price]" 
                                                               class="form-control unit-price" min="0" step="0.01" value="{{ $item->price }}" required>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control amount" readonly value="{{ $item->total }}">
                                                    </td>
                                                    <td class="text-center align-middle">
                   
                      <a href="javascript:void(0);"
                                                            class="text-danger fs-5 remove-row" title="Remove Row">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-lg-6 mb-3 d-flex">
                                    <div class="col-lg-6">
                                        <label for="discount_type" class="form-label">Discount type:</label>
                                        <select name="discount_type" id="discount_type" class="form-select" disabled>
                                            <option value="">Select discount type</option>
                                            {{-- @foreach ($discount_types as $type)
                                                <option value="{{ $type->id }}" {{ $quote->discount_type == $type->id ? 'selected' : '' }}>
                                                    {{ $type->type }}
                                                </option>
                                            @endforeach --}}
                                        </select>
                                    </div>
                                    <div class="col-lg-6">
                                        <label for="discount" class="form-label">Discount:</label>
                                        <input type="number" id="discount" name="discount" class="form-control" min="0"
                                            step="0.01" {{--value="{{ $quote->discount }}"--}} disabled>
                                    </div>
                                </div>
                                <div class="col-lg-5 mb-3">
                                    <div class="card shadow-lg">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Sub Total:</span>
                                                <span id="sub-total">{{ $quote->sub_total }} ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Discount:</span>
                                                <span id="discount-amt">{{ $quote->discount_amount }} ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Total:</span>
                                                <span id="total-amt">{{ $quote->total_amount }} ₹</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                                        
                            <input type="hidden" id="hidden-sub-total" name="sub_total" value="{{ $quote->sub_total }}">
                            <input type="hidden" id="hidden-discount-amt" name="discount_amount" value="{{ $quote->discount_amount }}">
                            <input type="hidden" id="hidden-total-amt" name="total_amount" value="{{ $quote->total_amount }}">
                            <input type="hidden" id="hidden-total-amt" name="type" value="{{ $type }}">

                            <div class="modal-footer mt-4">
                                <button type="submit" id="submit" class="btn btn-primary">@if ($type == 'edit')
                                    Update
                                    @elseif($type == 'convert')
                                    Convert
                                @endif </button>
                                <a href="{{ route('quotes-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
@endsection

@push('scripts')
    <script>
         const isAvl = @json($branch->avl_qty_flag);
        $(document).ready(function () {
            let rowCount = {{ count($quote->quotesItem) }};

            // Initialize the toggle button text based on the initial state
            if ($('#notes-terms').is(':visible')) {
                $('#toggle-notes').html('<i class="fas fa-minus"></i> Remove Note & Term');
            }

            // Add row button
            $('#add-row').click(function () {
                rowCount++;
                const row = `
                    <tr class="product-row">
                       <td>${rowCount}</td>
                        <td>
                            <select name="products[${rowCount}][id]" class="form-select product-select" required>
                                <option value="">Select Product</option>
                                @foreach ($products as $product)
                                    <option value="{{ $product->id }}" 
                                            data-available="{{ $product->qty }}" 
                                            data-amount=0 
                                            data-price="{{ $product->unit_price }}">
                                        {{ $product->code }}-{{ $product->branch->native_name_flag == 'A' ? ($product->native_name ?? $product->name) : $product->name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="duplicate-warning-container"></div>
                        </td>
                        <td>
                            <input type="text" class="form-control available-qty" readonly>
                        </td>
                        <td>
                            <input type="number" name="products[${rowCount}][qty]" 
                                   class="form-control qty" step="1" min="1" required>
                        </td>
                        <td>
                            <input type="number" name="products[${rowCount}][unit_price]" 
                                   class="form-control unit-price" min="0" step="0.01" required>
                        </td>
                        <td>
                            <input type="text" class="form-control amount" readonly>
                        </td>
                         <td class="text-center align-middle">
                   
                      <a href="javascript:void(0);"
                                                            class="text-danger fs-5 remove-row" title="Remove Row">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                    </td>
                    </tr>
                `;
                $('#products-table tbody').append(row);
                 $('#products-table tbody tr:last .product-select').select2({
                    placeholder: "Select Product",
                    width: '100%'
                });
            });
            $('.product-select').select2({
                placeholder: "Select Product",
                width: '100%'
            });

            // Remove row
            $(document).on('click', '.remove-row', function () {
                $(this).closest('tr').remove();
                calculateTotals();
                renumberRows();
            });

            // Product select change
            // $(document).on('change', '.product-select', function () {
            //     const selectedOption = $(this).find('option:selected');
            //     const availableQty = selectedOption.data('available');
            //     const price = selectedOption.data('price');

            //     const row = $(this).closest('tr');
            //     row.find('.available-qty').val(availableQty);
            //     row.find('.qty').val(1);
            //     row.find('.unit-price').val(price);

            //     calculateRowAmount(row);
            //     calculateTotals();
            // });
             $(document).on('change', '.product-select', function () {
                const selectedOption = $(this).find('option:selected');
                const availableQty = selectedOption.data('available');
                const price = selectedOption.data('price');
                const productId = $(this).val();

                const row = $(this).closest('tr');
                row.find('.available-qty').val(availableQty);
                row.find('.qty').val(1);
                row.find('.unit-price').val(price);

                $('.duplicate-warning').remove();
                $('.duplicate-row').removeClass('duplicate-row');

                if (productId) {
                    let duplicateFound = false;

                    $('.product-select').each(function () {
                        if ($(this).val() === productId && $(this).closest('tr')[0] !== row[0]) {
                            duplicateFound = true;
                            row.addClass('duplicate-row');
                            $(this).closest('tr').addClass('duplicate-row');

                            const warningHTML = `
                            <div class="duplicate-warning text-danger small mt-1">
                                <i class="fas fa-exclamation-triangle"></i> Duplicate Product
                            </div>
                        `;

                            row.find('.duplicate-warning-container').html(warningHTML);
                            $(this).closest('tr').find('.duplicate-warning-container').html(warningHTML);
                        }
                    });

                    $('#add-row').prop('disabled', duplicateFound);
                    $('#submit').prop('disabled', duplicateFound);
                }

                calculateRowAmount(row);
                calculateTotals();
            });

            // Quantity or unit price change
            $(document).on('change', '.qty, .unit-price', function () {
                const row = $(this).closest('tr');
                calculateRowAmount(row);
                calculateTotals();
            });

            $('.product-row').each(function() {
        const row = $(this);
        const amount = parseFloat(row.find('.amount').val()) || 0;
        const name = row.find('.product-select').attr('name').replace('[id]', '[amount]');
        
        // Add hidden input if it doesn't exist
        if (row.find('input[name^="products"][name$="[amount]"]').length === 0) {
            row.append($('<input>').attr({
                type: 'hidden',
                name: name,
                value: amount.toFixed(2)
            }));
        }
    });
            // Discount type or amount change
            $('#discount').prop('disabled', $('#discount_type').val() === '');
            $(document).on('change', '#discount_type', function () {
                const discountType = $(this).val();
                if (discountType) {
                    $('#discount').prop('disabled', false);
                } else {
                    $('#discount').prop('disabled', true).val('');
                }
                calculateTotals();
            });
            $(document).on('input', '#discount', function () {
                calculateTotals();
            });           

            // Calculate row amount
            function calculateRowAmount(row) {
                const qty = parseFloat(row.find('.qty').val()) || 0;
                const unitPrice = parseFloat(row.find('.unit-price').val()) || 0;
                const amount = qty * unitPrice;

                row.find('.amount').val(amount.toFixed(2));

                // Add or update hidden input for the amount
                let amountInput = row.find('input[name^="products"][name$="[amount]"]');
                if (amountInput.length === 0) {
                    const name = row.find('.product-select').attr('name').replace('[id]', '[amount]');
                    amountInput = $('<input>').attr({
                        type: 'hidden',
                        name: name,
                        value: amount.toFixed(2)
                    });
                    row.append(amountInput);
                } else {
                    amountInput.val(amount.toFixed(2));
                }
            }
            
            // Calculate totals
            function calculateTotals() {
                let subTotal = 0;

                $('.product-row').each(function () {
                    const amount = parseFloat($(this).find('.amount').val()) || 0;
                    if (!isNaN(amount)) {
                        subTotal += amount;
                    }
                });

                const discountType = $('#discount_type').val();
                const discount = parseFloat($('#discount').val()) || 0;
                let discountAmount = 0;
                
                if (discountType == 2) {
                    if (discount >= 0 && discount <= 100) {
                        discountAmount = (subTotal * discount) / 100;
                    } else {
                        $('#discount').val('');
                        discountAmount = 0;
                    }
                } else if (discountType == 1) {
                    discountAmount = Math.min(discount, subTotal);
                }

                const total = Math.max(0, subTotal - discountAmount);

                // Update totals in the UI
                $('#sub-total').text(subTotal.toFixed(2) + ' ₹');
                $('#discount-amt').text(discountAmount.toFixed(2) + ' ₹');
                $('#total-amt').text(total.toFixed(2) + ' ₹');

                // Update hidden inputs
                $('#hidden-sub-total').val(subTotal.toFixed(2));
                $('#hidden-discount-amt').val(discountAmount.toFixed(2));
                $('#hidden-total-amt').val(total.toFixed(2));
            }

            // Renumber rows
            function renumberRows() {
                let count = 1;
                $('.product-row').each(function () {
                    $(this).find('td:first').text(count);
                    count++;
                });
            }

            // Initialize the totals calculation on page load
            calculateTotals();
        });
    </script>
@endpush