@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add New Category</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('category-store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="categoryName" class="form-label">Category Name</label>
                                    <input type="text" id="categoryName" name="categoryName" class="form-control" 
                                           value="{{ old('categoryName') }}" 
                                           placeholder="Enter category name" 
                                           required>
                                    @error('categoryName')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="selectedUOM" class="form-label">UOM (Unit of Measurement)</label>
                                    <select id="selectedUOM" name="selectedUOM" class="form-control" required>
                                        <option value="" selected disabled>Select UOM</option>
                                        @foreach($uoms as $uom)
                                            <option value="{{ $uom->id }}" {{ old('selectedUOM') == $uom->id ? 'selected' : '' }}>
                                                {{ $uom->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('selectedUOM')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary">Save Category</button>
                                <a href="{{ route('category-index') }}" class="btn btn-secondary ms-2">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection